#!/usr/bin/python
# coding: UTF-8
# Rec10 TS Recording Tools
# Copyright (C) 2009 Yukikaze
import datetime
import os
import re
import sys
import time

import chdb
import checker
import configreader
import epgdb
import rec10d
import recdb
import status
import tv2avi
import tv2mkv
recpath = configreader.getpath('recpath')
path = str(os.path.dirname(os.path.abspath(__file__))) + "/"
def task():
    """
    数分毎に実行されるタスク処理
    予定によって子プロセスを生成し処理する。
    """
    recdb.delete_old("24")
    tasks = recdb.getnow("2")
    #print tasks
    inum = recdb.countRecNow_minutes("10")
    #inum=recdb.countRecNow("1")
    print "番組表更新処理"+ datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
    print "inum:" + str(inum) + "bscsrec:" + str(status.getBSCSRecording()) + "terec:" + str(status.getTERecording()) 

    #if inum+status.getBSCSRecording()+status.getTERecording() < 2:
    encodenum=0
    b25num=0
    update = chdb.update()
    print update
    if len(update) > 0:
        pid = os.fork()
        if pid != 0:
            time.sleep(1)
        else:
            i = 0
            for bctype in update:
                recnum = 0
                if bctype.find('te') > -1:
                    recnum = status.getTERecording() + recdb.countRecNow_minutes_TE("10")
                    print bctype + "//ing:" + str(status.getTERecording()) + ":task:" + str(recdb.countRecNow_minutes_TE("10"))
                else:
                    recnum = status.getBSCSRecording() + recdb.countRecNow_minutes_BSCS("10")
                    print bctype + "//ing:" + str(status.getBSCSRecording()) + ":task:" + str(recdb.countRecNow_minutes_BSCS("10"))
                if recnum < 2:
                    print update
                    rec10d.rec10db.update_status_by_bctype_chdata(bctype, "0")
                    epgdb.updatebc(bctype)
                    update = chdb.update()
                    i = i + 1
                    #rec10d.rec10db.update_by_bctype_chdata(bctype)
                if i > 0:
                    break
            sys.exit()
    for task in tasks:
        #print task
        try:
            chtxt = task['chtxt']
        except:
            chtxt = ""
        try:
            title = task['title']
        except:
            title = ""
        try:
            btime = task['btime']
            bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
        except:
            btime = ""
            bt = datetime.datetime.strptime("2009-01-01 00:00:00", "%Y-%m-%d %H:%M:%S")
        try:
            etime = task['etime']
            et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
        except:
            etime = ""
            et = datetime.datetime.strptime("2009-01-01 00:00:00", "%Y-%m-%d %H:%M:%S")
        try:
            opt = task['opt']
        except:
            opt = ""
        #print title
        #print task
        tnow = datetime.datetime.now()
        dtt = bt-tnow
        dt = dtt.days * 24 * 60 * 60 + dtt.seconds
        #print title+str(dt)
        if task["type"] == recdb.REC_RESERVE:#"res,"+chtxt+","+title+","+btime+","+etime+","+opt
            if (dt < 58 * 60 and dt > 20 * 60):
                pid = os.fork()
                if pid != 0:#親プロセスの場合
                    ""
                else:#子プロセスの場合　アップデートを行って終了
                    bctypet = chdb.chtxtsearch(chtxt)['bctype']
                    chdatat = rec10d.rec10db.select_by_bctype_chdata(bctypet)
                    dt1 = datetime.datetime.strptime(chdatat[0][5], "%Y-%m-%d %H:%M:%S")-datetime.datetime.now()
                    dt1 = dt1.days * 24 * 60 * 60 + dt1.seconds
                    #print "oikake search:"+str(dt1)
                    if dt1 < 60 * 60:
                        recdata = epgdb.searchtime2(title.decode('utf-8'), btime, "5", chtxt)
                        chtxtn = recdata[0]
                        titlen = recdata[1]
                        btimen = recdata[2]
                        etimen = recdata[3]
                        bt = datetime.datetime.strptime(btimen, "%Y-%m-%d %H:%M:%S")
                        et = datetime.datetime.strptime(etimen, "%Y-%m-%d %H:%M:%S")
                        btimen = bt.strftime("%Y-%m-%d %H:%M:%S")
                        etimen = et.strftime("%Y-%m-%d %H:%M:%S")
                        if chtxt != "":
                            try:
                                recdb.del_reckey(recdb.REC_RESERVE, title, chtxt, btime)
                                recdb.rec_reckey(recdb.REC_FINAL_RESERVE, titlen, chtxtn, btimen, etimen, opt)
                                print "Oikake "+title+" : "+titlen+" "+btimen+" "+etimen
                            except Exception, inst:
                                print type(inst)
                                print inst
                        else:
                            print "nothing match"
                    else:
                        #print rec10d.rec10db.select_by_bctype_chdata(bctypet)
                        if rec10d.rec10db.select_by_bctype_chdata(bctypet)[0][6] != "0":
                            rec10d.rec10db.update_status_by_bctype_chdata(bctypet, "3")
                    sys.exit()
            elif dt <= 20 * 60:
                try:
                    recdb.del_reckey(recdb.REC_RESERVE, title, chtxt, btime)
                    recdb.rec_reckey(recdb.REC_FINAL_RESERVE, title, chtxt, btime, etime, opt)
                except Exception, inst:
                    print type(inst)
                    print inst
        elif task["type"] == recdb.REC_KEYWORD:#"key,"+chtxt+","+keyword+","+btime+","+deltatime+","+opt
            deltatime = task['deltatime']
            if dt < 90 * 60:
                recdata = epgdb.searchtime2(title.decode('utf-8'), btime, deltatime, chtxt)
                if recdata[1] != "":
                    chtxtt = recdata[0]
                    titlet = recdata[1]
                    btimet = recdata[2]
                    etimet = recdata[3]
                    bt = datetime.datetime.strptime(btimet, "%Y-%m-%d %H:%M:%S")
                    et = datetime.datetime.strptime(etimet, "%Y-%m-%d %H:%M:%S")
                    btimet = bt.strftime("%Y-%m-%d %H:%M:%S")
                    etimet = et.strftime("%Y-%m-%d %H:%M:%S")
                    try:
                        recdb.del_reckey(recdb.REC_KEYWORD, title, chtxt, btime)
                        recdb.rec_reckey(recdb.REC_RESERVE, titlet, chtxtt, btimet, etimet, opt)
                        print "key "+title+" : "+titlet+" "+btimet+" "+etimet
                    except Exception, inst:
                        print type(inst)
                        print inst
                else:
                    print "nothing match"
        elif task["type"] == recdb.REC_KEYWORD_EVERY_SOME_DAYS:#"keyevery,"+chtxt+","+keyword+","+btime+","+deltatime+","+opt+","+deltaday
            deltatime = task['deltatime']
            deltaday = task['deltaday']
            dd = datetime.timedelta(days=int(deltaday))
            if dtt.days < 0:
                recdb.del_reckey(recdb.REC_KEYWORD_EVERY_SOME_DAYS, title, chtxt, btime)
                bt = bt + dd
                et = et + dd
                btxt = bt.strftime("%Y-%m-%d %H:%M:%S")
                etxt = et.strftime("%Y-%m-%d %H:%M:%S")
                recdb.everyreserv(title, chtxt, btxt, etxt, deltatime, opt, deltaday)
            elif dt < 120 * 60:
                recdb.keyreserv(title, chtxt, btime, etime, deltatime, opt)
                recdb.del_reckey(recdb.REC_KEYWORD_EVERY_SOME_DAYS, title, chtxt, btime)
                bt = bt + dd
                et = et + dd
                btxt = bt.strftime("%Y-%m-%d %H:%M:%S")
                etxt = et.strftime("%Y-%m-%d %H:%M:%S")
                recdb.everyreserv(title, chtxt, btxt, etxt, deltatime, opt, deltaday)
            
        elif task["type"] == recdb.REC_FINAL_RESERVE:#"rec,"+chtxt+","+title+","+btime+","+etime+","+opt
            print dt
            if dt < 6 * 60 and dt > 0:
                recdb.del_reckey(recdb.REC_FINAL_RESERVE, title, chtxt, btime)
                recdb.rec_reckey(recdb.REC_TS_RECORDING, title, chtxt, btime, etime, opt)
                print "録画開始 "+title+" "+btime+" "+etime
                pid = os.fork()
                if pid != 0:#親プロセスの場合
                    ""
                else:
                    ttitle=title
                    #print title
                    testpath=[os.path.join(recpath,title+".ts.b25")]
                    testpath.append(os.path.join(recpath,title+".ts"))
                    testpath.append(os.path.join(recpath,title+".avi"))
                    testpath.append(os.path.join(recpath,title+".mkv"))
                    testpath.append(os.path.join(recpath,title+".log"))
                    tcheck=0
                    for ti in testpath:
                        if os.path.exists(ti):
                            tcheck=tcheck+1
                    if tcheck>0:
                        ttitle=title+"_"+datetime.datetime.now().strftime("%Y%m%d%H%M")
                    tv2avi.timetv2b25(recpath + "/" + ttitle + ".avi", chtxt, btime, etime, opt)
                    recdb.del_reckey(recdb.REC_TS_RECORDING, title, chtxt, btime)
                    tnow = datetime.datetime.now()
                    bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
                    et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
                    dt = tnow-bt
                    bt = tnow + datetime.timedelta(seconds=600)
                    et = et + dt + datetime.timedelta(seconds=600)
                    btime = bt.strftime("%Y-%m-%d %H:%M:%S")
                    etime = et.strftime("%Y-%m-%d %H:%M:%S")
                    recdb.rec_reckey(recdb.REC_TS_DECODE_QUE, ttitle, chtxt, btime, etime, opt)
                    sys.exit()
        elif task["type"] == recdb.REC_TS_DECODE_QUE:
            if dt < 10 * 60:
                b25num=b25num+1
                pid = os.fork()
                if pid != 0:#親プロセスの場合
                    ""
                else:
                    if b25num>1:
                        time.sleep(5*b25num)
                    if status.getB25Decoding() < 2:
                        pin = recpath + "/" + title
                        recdb.del_reckey(recdb.REC_TS_DECODE_QUE, title, chtxt, btime)
                        recdb.rec_reckey(recdb.REC_TS_DECODING, title, chtxt, btime, etime, opt)
                        tv2avi.b252ts(pin, chtxt, btime, etime, opt)
                        recdb.del_reckey(recdb.REC_TS_DECODING, title, chtxt, btime)
                        if not os.access(recpath + "/" + title + ".ts", os.F_OK):
                            recdb.del_reckey(recdb.REC_TS_DECODING, title, chtxt, btime)
                            recdb.rec_reckey(recdb.REC_MISS_DECODE, title, chtxt, btime, etime, opt)
                        bt = datetime.datetime.strptime(btime, "%Y-%m-%d %H:%M:%S")
                        et = datetime.datetime.strptime(etime, "%Y-%m-%d %H:%M:%S")
                        dt = et-bt
                        tnow = datetime.datetime.now()
                        bt = tnow + datetime.timedelta(seconds=900)
                        et = bt + dt
                        btime = bt.strftime("%Y-%m-%d %H:%M:%S")
                        etime = et.strftime("%Y-%m-%d %H:%M:%S")
                        recdb.rec_reckey(recdb.REC_ENCODE_QUE, title, chtxt, btime, etime, opt)
                        #print checker.checkB25Decode(recpath + "/" + title + ".ts.b25", recpath + "/" + title + ".ts")
                        #if checker.checkB25Decode(recpath + "/" + title + ".ts.b25", recpath + "/" + title + ".ts") == 1:
                            #os.remove(recpath + "/" + title + ".ts.b25")
                        sys.exit()
                    else:
                        recdb.del_reckey(recdb.REC_TS_DECODE_QUE, title, chtxt, btime)
                        bt = bt + datetime.timedelta(seconds=600)
                        et = et + datetime.timedelta(seconds=600)
                        btime = bt.strftime("%Y-%m-%d %H:%M:%S")
                        etime = et.strftime("%Y-%m-%d %H:%M:%S")
                        recdb.rec_reckey(recdb.REC_TS_DECODE_QUE, title, chtxt, btime, etime, opt)
                        sys.exit()
        elif task["type"] == recdb.REC_ENCODE_QUE:
            if dt < 10 * 60:
                encodenum=encodenum+1
                pid = os.fork()
                if pid > 0:#親プロセスの場合
                    ""
                else:
                    if encodenum>1:
                        time.sleep(5*encodenum)
                    if status.getEncoding() < int(configreader.getenv("enc_max")):
                        print opt
                        pin = recpath + "/" + title + ".ts"
                        if re.search("d", opt):
                            pin = recpath + "/" + title + ".sa.avi"
                        if re.search("5", opt):
                            pin = recpath + "/" + title + ".sa.avi"
                        #pout = recpath + "/" + title + ".avi"
                        pout = recpath + "/" + title + ".mkv"
                        print [pin, pout, opt]
                        print pin
                        #print pin+":"+pout+":"+opt
                        recdb.del_reckey(recdb.REC_ENCODE_QUE, title, chtxt, btime)
                        recdb.rec_reckey(recdb.REC_ENCODE_LOCAL, title, chtxt, btime, etime, opt)
                        tv2mkv.ts2mkv(pin, pout, opt)
                        #tv2avi.ts2avi(pin, pout, opt)
                        recdb.del_reckey(recdb.REC_ENCODE_LOCAL, title, chtxt, btime)
                        recdb.rec_reckey(recdb.REC_FIN_LOCAL, title, chtxt, btime, etime, opt)
                        sys.exit()
                    else:
                        recdb.del_reckey(recdb.REC_ENCODE_QUE, title, chtxt, btime)
                        bt = bt + datetime.timedelta(seconds=600)
                        et = et + datetime.timedelta(seconds=600)
                        btime = bt.strftime("%Y-%m-%d %H:%M:%S")
                        etime = et.strftime("%Y-%m-%d %H:%M:%S")
                        recdb.rec_reckey(recdb.REC_ENCODE_QUE, title, chtxt, btime, etime, opt)
                        sys.exit()
    sys.exit()